// In this file, we implement the sample streaming algorithm by Feldman, Karbasi, and Kazemi.
// Given that their algorithm does not support deletion, each time that a selected element
// is deleted, we restart algorithm after deletion of that element.
// In this code, we assume that elements are removed in order they inserted
#include<bits/stdc++.h>
#include "oracle.h"
using namespace std;
typedef long double ld;
// Vector S refers to selected elements and fS[i] maintain f(S[i]|S[0..i-1]).
// The elements keep elements in order they come.
// Also insertion_time[i] is refering to index of element i at vector elements. 
const int maxn = 1e6;
vector<int> S, elements;
vector<ld> fS;
int k, insertion_time[maxn];
double q, c;

// Compute f(S)
ld ans()
{
  ld ret = 0;
  for(int i = 0; i < fS.size(); i ++)
    ret += fS[i];
  //  cout<<k<<" "<<fS.size()<<" "<<S.size()<<endl;
  return ret;
}

// Add element element_id
ld add_element(int element_id)
{
  elements.push_back(element_id);
  insertion_time[element_id] = elements.size();
  // With probability 1-q, drop the element_id
  if((double) rand()/RAND_MAX > q)
    return ans();
  // Find how much value the element_id will add to S
  S.push_back(element_id);
  ld additive_value = f(S) - accumulate(fS.begin(), fS.end(), (ld)0.0);
  // If we can add element_id without exceeding cardinality constraint and f(element_id|S)>=0, add it
  if(S.size() <= k)
    {
      if(additive_value >= 0)
	fS.push_back(additive_value);
      else
	S.pop_back();
      return ans();
    }
  // Now we select element u with minimum value of f(u:S) and keep its index in  minimum_element
  // Then wereplace it with element_id if f(element_id|S) >= (1+c) * f(S[minimum_elemnt]:S)
  int minimum_element = min_element(fS.begin(), fS.end()) - fS.begin();
  if(additive_value >= (1 + c) * fS[minimum_element])
    {
      vector<int> new_S;
      for(int i = 0; i < minimum_element; i ++)
	new_S.push_back(S[i]);
      for(int i = minimum_element; i < k; i ++)
	{
	  new_S.push_back(S[i + 1]);
	  fS[i] = f(new_S) - accumulate(fS.begin(), fS.begin() + i, (ld)0.0);
	}
      S = new_S; 
    }
  else
    S.pop_back();
  return ans();
}

// Remove element_id
ld remove_element(int element_id)
{
  // Check if element_id has been selected
  bool selected = false;
  for(int i = 0; i < S.size(); i ++)
    if(S[i] == element_id)
      selected = true;
  // Remove it if it is selected. Then restart the algorithm
  if(selected)
    {
      // Here we assume that elements are removed in the order they iserted.
      // So we remove all elements and then we add all elements after element_id one by one 
      int start_time = insertion_time[element_id];
      S.clear();
      fS.clear();
      vector<int> remaining_elements(elements.begin() + start_time, elements.end());
      elements.clear();
      for(int i = 0; i < remaining_elements.size(); i ++)
	add_element(remaining_elements[i]);
    }
  return ans();
}

// Initialize value c and q  according to the paper
// Do less, get more: Streaming submodular maximization with subsampling
// Note that cardinality constarint is special case of p-matchoid with p = m = 1
void init(int K)
{
  srand(5000);
  k = K;
  q = 1.0 / (2.0 + sqrt(2));
  c = sqrt(2);
}

void print_selected_elements()
{
  for(int i = 0; i < S.size(); i ++)
    cout << S[i] << " ";
  cout << endl;
}
